/* --------------------------------------------------------------
 core_workarounds.js 2019-10-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Core Workarounds Module
 *
 * This file contains workarounds that do not belong in other JS modules.
 */
gambio.widgets.module('core_workarounds', [], function () {

    'use strict';

    var module = {};

    var _initMobileMenu = function () {
        var $profile = $('#topbar-container nav > ul> li').clone(),
            $login = $profile.find('.login-off-item'),
            $loginClone = $login.clone();

        $loginClone.addClass('dropdown navbar-topbar-item');
        $login.remove();
        $profile = $profile.add($loginClone);

        $('#categories nav > ul').append($profile);
        $('#categories nav > ul').attr('data-gambio-widget', 'link_crypter');  //reinitialize widgets
        gambio.widgets.init($('#categories nav > ul'));

        var $verticalMenu = $('.navbar-categories-left');
        if ($verticalMenu.length > 0) {
            $verticalMenu.find('ul.level-1').append($profile.clone());

            $verticalMenu.find('ul.level-1').attr('data-gambio-widget', 'link_crypter');
            gambio.widgets.init($verticalMenu.find('ul.level-1'));

            // hide the new elements
            $verticalMenu.find('.navbar-topbar-item').hide();
        }
    };

    var _initIE11Workarounds = function () {
        var isIE11 = !(window.ActiveXObject) && "ActiveXObject" in window;
        if(!isIE11) {
            return;
        }

        // crude workaround for IE11’s inability to handle HTML5 form attributes
        var extFormButtons = $('button.extform');
        extFormButtons.each(function() {
            var formId = $(this).attr('form');
            $(this).on('click', function() {
                var formInputs = $('input[form="' + formId + '"]');
                var theForm = $('form#' + formId);
                formInputs.each(function() {
                    theForm.append($('input').attr('type', 'hidden').attr('name', $(this).attr('name')).attr('value', $(this).val()));
                })
                theForm.submit();
            })
        });
    }

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        _initMobileMenu();
        _initIE11Workarounds();
        
        done();
    };

    return module;
});
